/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.editor;

import de.dfki.mycbr.core.casebase.SymbolAttribute;
import de.dfki.mycbr.core.model.SymbolDesc;
import de.dfki.mycbr.core.similarity.Similarity;
import de.dfki.mycbr.core.similarity.TaxonomyFct;
import de.dfki.mycbr.core.similarity.TaxonomyNode;
import de.dfki.mycbr.core.similarity.config.TaxonomyConfig;
import de.dfki.mycbr.gui.function.editor.SetSimilarityWizard;
import de.dfki.mycbr.gui.function.editor.TaxonomyEditorInput;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class TaxonomyEditor
extends EditorPart
implements Observer {
    public static final String ID = "de.dfki.mycbr.gui.function.editor.TaxonomyEditor";
    private TaxonomyFct function;
    private Button[] btnSymmetry;
    private TreeViewer trvTaxonomy;
    private Group cmpInnerNodesQuery;
    private Group cmpInnerNodesCase;
    private Group cmpSemanticsInnerNodesQuery;
    private Group cmpSemanticsInnerNodesCase;
    private Group cmpSemanticsUncertainQuery;
    private Group cmpSemanticsUncertainCase;
    private Button[] btnInnerNodesQuery;
    private Button[] btnInnerNodesCase;
    private Button[] btnSemanticsInnerNodesQuery;
    private Button[] btnSemanticsInnerNodesCase;
    private Button[] btnSemanticsUncertainQuery;
    private Button[] btnSemanticsUncertainCase;
    private Button btnSetSimilarity;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.function = ((TaxonomyEditorInput)input).getFunction();
        this.setPartName(this.function.getName());
        this.function.addObserver((Observer)this);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.createUi(parent);
        this.fillModel();
        this.addDirtyOnChangeListeners();
    }

    private void createUi(Composite parent) {
        Label lblSymmetry = new Label(parent, 0);
        lblSymmetry.setText("Symmetry");
        Composite cmpSymmetryGroup = new Composite(parent, 0);
        cmpSymmetryGroup.setLayout((Layout)new RowLayout(256));
        this.btnSymmetry = new Button[2];
        this.btnSymmetry[0] = new Button(cmpSymmetryGroup, 16);
        this.btnSymmetry[0].setText("symmetric");
        this.btnSymmetry[1] = new Button(cmpSymmetryGroup, 16);
        this.btnSymmetry[1].setText("asymmetric");
        Composite cmpSettingsGroup = new Composite(parent, 0);
        cmpSettingsGroup.setLayout((Layout)new GridLayout(3, false));
        Label lblInnerNodes = new Label(cmpSettingsGroup, 0);
        lblInnerNodes.setText("Inner nodes as values");
        this.cmpInnerNodesQuery = new Group(cmpSettingsGroup, 16);
        this.cmpInnerNodesQuery.setText("Query");
        this.cmpInnerNodesQuery.setLayout((Layout)new FillLayout(512));
        this.btnInnerNodesQuery = new Button[2];
        this.btnInnerNodesQuery[0] = new Button((Composite)this.cmpInnerNodesQuery, 16);
        this.btnInnerNodesQuery[0].setText("no");
        this.btnInnerNodesQuery[1] = new Button((Composite)this.cmpInnerNodesQuery, 16);
        this.btnInnerNodesQuery[1].setText("yes");
        this.cmpInnerNodesCase = new Group(cmpSettingsGroup, 16);
        this.cmpInnerNodesCase.setText("Case");
        this.cmpInnerNodesCase.setLayout((Layout)new FillLayout(512));
        this.btnInnerNodesCase = new Button[2];
        this.btnInnerNodesCase[0] = new Button((Composite)this.cmpInnerNodesCase, 16);
        this.btnInnerNodesCase[0].setText("no");
        this.btnInnerNodesCase[1] = new Button((Composite)this.cmpInnerNodesCase, 16);
        this.btnInnerNodesCase[1].setText("yes");
        Label lblSemanticsInnerNodes = new Label(cmpSettingsGroup, 0);
        lblSemanticsInnerNodes.setText("Semantics of inner nodes");
        this.cmpSemanticsInnerNodesQuery = new Group(cmpSettingsGroup, 16);
        this.cmpSemanticsInnerNodesQuery.setText("Query");
        this.cmpSemanticsInnerNodesQuery.setLayout((Layout)new FillLayout(512));
        this.btnSemanticsInnerNodesQuery = new Button[2];
        this.btnSemanticsInnerNodesQuery[0] = new Button((Composite)this.cmpSemanticsInnerNodesQuery, 16);
        this.btnSemanticsInnerNodesQuery[0].setText("any value");
        this.btnSemanticsInnerNodesQuery[1] = new Button((Composite)this.cmpSemanticsInnerNodesQuery, 16);
        this.btnSemanticsInnerNodesQuery[1].setText("uncertain");
        this.cmpSemanticsInnerNodesCase = new Group(cmpSettingsGroup, 16);
        this.cmpSemanticsInnerNodesCase.setText("Case");
        this.cmpSemanticsInnerNodesCase.setLayout((Layout)new FillLayout(512));
        this.btnSemanticsInnerNodesCase = new Button[2];
        this.btnSemanticsInnerNodesCase[0] = new Button((Composite)this.cmpSemanticsInnerNodesCase, 16);
        this.btnSemanticsInnerNodesCase[0].setText("any value");
        this.btnSemanticsInnerNodesCase[1] = new Button((Composite)this.cmpSemanticsInnerNodesCase, 16);
        this.btnSemanticsInnerNodesCase[1].setText("uncertain");
        Label lblSemanticsUncertain = new Label(cmpSettingsGroup, 0);
        lblSemanticsUncertain.setText("Semantics of uncertain");
        this.cmpSemanticsUncertainQuery = new Group(cmpSettingsGroup, 16);
        this.cmpSemanticsUncertainQuery.setText("Query");
        this.cmpSemanticsUncertainQuery.setLayout((Layout)new FillLayout(512));
        this.btnSemanticsUncertainQuery = new Button[3];
        this.btnSemanticsUncertainQuery[0] = new Button((Composite)this.cmpSemanticsUncertainQuery, 16);
        this.btnSemanticsUncertainQuery[0].setText("pessimistic");
        this.btnSemanticsUncertainQuery[1] = new Button((Composite)this.cmpSemanticsUncertainQuery, 16);
        this.btnSemanticsUncertainQuery[1].setText("optimistic");
        this.btnSemanticsUncertainQuery[2] = new Button((Composite)this.cmpSemanticsUncertainQuery, 16);
        this.btnSemanticsUncertainQuery[2].setText("average");
        this.cmpSemanticsUncertainCase = new Group(cmpSettingsGroup, 16);
        this.cmpSemanticsUncertainCase.setText("Case");
        this.cmpSemanticsUncertainCase.setLayout((Layout)new FillLayout(512));
        this.btnSemanticsUncertainCase = new Button[3];
        this.btnSemanticsUncertainCase[0] = new Button((Composite)this.cmpSemanticsUncertainCase, 16);
        this.btnSemanticsUncertainCase[0].setText("pessimistic");
        this.btnSemanticsUncertainCase[1] = new Button((Composite)this.cmpSemanticsUncertainCase, 16);
        this.btnSemanticsUncertainCase[1].setText("optimistic");
        this.btnSemanticsUncertainCase[2] = new Button((Composite)this.cmpSemanticsUncertainCase, 16);
        this.btnSemanticsUncertainCase[2].setText("average");
        this.trvTaxonomy = new TreeViewer(parent, 2820);
        this.trvTaxonomy.setContentProvider((IContentProvider)new TaxonomyTreeContentProvider());
        this.trvTaxonomy.setLabelProvider((IBaseLabelProvider)new TaxnomonyTreeLabelProvider());
        this.trvTaxonomy.setInput((Object)new Object[]{this.function.getDesc()});
        this.trvTaxonomy.expandAll();
        final Shell shell = parent.getShell();
        this.trvTaxonomy.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                Object o = ss.getFirstElement();
                if (o instanceof SymbolAttribute) {
                    SymbolAttribute attribute = (SymbolAttribute)o;
                    IInputValidator validator = new IInputValidator(){

                        public String isValid(String newText) {
                            Double value = Double.valueOf(newText);
                            if (newText.isEmpty()) {
                                return "You must enter a value";
                            }
                            if (value < 0.0 || value > 1.0) {
                                return "The value must be between 0 and 1";
                            }
                            return null;
                        }
                    };
                    InputDialog inputDialog = new InputDialog(shell, "Change similarity", "Please enter a value between 0 and 1", TaxonomyEditor.this.function.getTaxonomy().getSimilarity((TaxonomyNode)attribute).toString(), validator);
                    inputDialog.open();
                    String newValue = inputDialog.getValue();
                    if (newValue != null) {
                        Double value = Double.valueOf(newValue);
                        TaxonomyEditor.this.function.setNodeSimilarity((TaxonomyNode)attribute, Similarity.get((Double)value));
                        TaxonomyEditor.this.trvTaxonomy.refresh();
                        try {
                            if (!TaxonomyEditor.this.function.getProject().getName().endsWith("_UNSAFED")) {
                                TaxonomyEditor.this.function.getProject().setName(String.valueOf(TaxonomyEditor.this.function.getProject().getName()) + "_UNSAFED");
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this.trvTaxonomy.addDragSupport(2, transfers, new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TaxonomyEditor.this.trvTaxonomy.getSelection();
                Object obj = selection.getFirstElement();
                String s = null;
                if (obj instanceof SymbolDesc) {
                    SymbolDesc desc = (SymbolDesc)obj;
                    s = desc.getName();
                } else if (obj instanceof SymbolAttribute) {
                    SymbolAttribute attribute = (SymbolAttribute)obj;
                    s = attribute.getValue();
                }
                event.data = s;
                try {
                    if (!TaxonomyEditor.this.function.getProject().getName().endsWith("_UNSAFED")) {
                        TaxonomyEditor.this.function.getProject().setName(String.valueOf(TaxonomyEditor.this.function.getProject().getName()) + "_UNSAFED");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public void dragStart(DragSourceEvent event) {
            }
        });
        this.trvTaxonomy.addDropSupport(2, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.trvTaxonomy){

            public boolean performDrop(Object data) {
                String targetStr = this.getCurrentTarget().toString();
                if (targetStr == null) {
                    return false;
                }
                String dropStr = (String)data;
                SymbolAttribute dropSymbol = this.findSymbolAttribute(dropStr);
                if (dropSymbol == null) {
                    return false;
                }
                Object targetObj = null;
                targetObj = targetStr.equals(TaxonomyEditor.this.function.getDesc().getName()) ? TaxonomyEditor.this.function.getDesc() : this.findSymbolAttribute(targetStr);
                try {
                    TaxonomyEditor.this.function.setParent((TaxonomyNode)dropSymbol, (TaxonomyNode)targetObj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                TaxonomyEditor.this.trvTaxonomy.refresh();
                try {
                    if (!TaxonomyEditor.this.function.getProject().getName().endsWith("_UNSAFED")) {
                        TaxonomyEditor.this.function.getProject().setName(String.valueOf(TaxonomyEditor.this.function.getProject().getName()) + "_UNSAFED");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return true;
            }

            private SymbolAttribute findSymbolAttribute(String name) {
                for (SymbolAttribute sa : TaxonomyEditor.this.function.getDesc().getSymbolAttributes()) {
                    if (!sa.getValue().equals(name)) continue;
                    return sa;
                }
                return null;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return true;
            }
        });
        if (this.function.getDesc().isMultiple()) {
            this.btnSetSimilarity = new Button(parent, 8);
            this.btnSetSimilarity.setText("Configure set similarity");
            this.btnSetSimilarity.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SetSimilarityWizard wizard = new SetSimilarityWizard(TaxonomyEditor.this.function.getMultipleConfig());
                    WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard){

                        public void updateButtons() {
                            super.updateButtons();
                            this.getButton(1).setEnabled(false);
                        }
                    };
                    wizardDialog.create();
                    wizardDialog.open();
                }
            });
        }
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(4).applyTo(parent);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)cmpSettingsGroup);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.trvTaxonomy.getTree());
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)cmpSymmetryGroup);
    }

    private void setInnerNodesCase(boolean enabled) {
        this.btnInnerNodesCase[0].setEnabled(enabled);
        this.btnInnerNodesCase[1].setEnabled(enabled);
    }

    private void setSemanticsInnerNodesQuery(boolean enabled) {
        this.btnSemanticsInnerNodesQuery[0].setEnabled(enabled);
        this.btnSemanticsInnerNodesQuery[1].setEnabled(enabled);
    }

    private void setSemanticsInnerNodesCase(boolean enabled) {
        this.btnSemanticsInnerNodesCase[0].setEnabled(enabled);
        this.btnSemanticsInnerNodesCase[1].setEnabled(enabled);
    }

    private void setSemanticsUncertainQuery(boolean enabled) {
        this.btnSemanticsUncertainQuery[0].setEnabled(enabled);
        this.btnSemanticsUncertainQuery[1].setEnabled(enabled);
        this.btnSemanticsUncertainQuery[2].setEnabled(enabled);
    }

    private void setSemanticsUncertainCase(boolean enabled) {
        this.btnSemanticsUncertainCase[0].setEnabled(enabled);
        this.btnSemanticsUncertainCase[1].setEnabled(enabled);
        this.btnSemanticsUncertainCase[2].setEnabled(enabled);
    }

    private void fillModel() {
        this.btnSymmetry[0].setSelection(this.function.isSymmetric());
        this.btnSymmetry[1].setSelection(!this.function.isSymmetric());
        this.fillSettings();
    }

    private void fillSettings() {
        this.disableAllSettingsButtons();
        switch (this.function.getQueryConfig()) {
            case NO_INNERNODES: {
                this.btnInnerNodesQuery[0].setSelection(true);
                this.setSemanticsInnerNodesQuery(false);
                this.setSemanticsUncertainQuery(false);
                break;
            }
            case INNER_NODES_ANY: {
                this.btnInnerNodesQuery[1].setSelection(true);
                this.btnSemanticsInnerNodesQuery[0].setSelection(true);
                this.setSemanticsInnerNodesQuery(true);
                this.setSemanticsUncertainQuery(false);
                break;
            }
            case INNER_NODES_PESSIMISTIC: {
                this.btnInnerNodesQuery[1].setSelection(true);
                this.btnSemanticsInnerNodesQuery[1].setSelection(true);
                this.btnSemanticsUncertainQuery[0].setSelection(true);
                this.setSemanticsInnerNodesQuery(true);
                this.setSemanticsUncertainQuery(true);
                break;
            }
            case INNER_NODES_OPTIMISTIC: {
                this.btnInnerNodesQuery[1].setSelection(true);
                this.btnSemanticsInnerNodesQuery[1].setSelection(true);
                this.btnSemanticsUncertainQuery[1].setSelection(true);
                this.setSemanticsInnerNodesQuery(true);
                this.setSemanticsUncertainQuery(true);
                break;
            }
            case INNER_NODES_AVERAGE: {
                this.btnInnerNodesQuery[1].setSelection(true);
                this.btnSemanticsInnerNodesQuery[1].setSelection(true);
                this.btnSemanticsUncertainQuery[2].setSelection(true);
                this.setSemanticsInnerNodesQuery(true);
                this.setSemanticsUncertainQuery(true);
            }
        }
        switch (this.function.getCaseConfig()) {
            case NO_INNERNODES: {
                this.btnInnerNodesCase[0].setSelection(true);
                this.setInnerNodesCase(true);
                this.setSemanticsInnerNodesCase(false);
                this.setSemanticsUncertainCase(false);
                break;
            }
            case INNER_NODES_ANY: {
                this.btnInnerNodesCase[1].setSelection(true);
                this.btnSemanticsInnerNodesCase[0].setSelection(true);
                this.setInnerNodesCase(true);
                this.setSemanticsInnerNodesCase(true);
                this.setSemanticsUncertainCase(false);
                break;
            }
            case INNER_NODES_PESSIMISTIC: {
                this.btnInnerNodesCase[1].setSelection(true);
                this.btnSemanticsInnerNodesCase[1].setSelection(true);
                this.btnSemanticsUncertainCase[0].setSelection(true);
                this.setInnerNodesCase(true);
                this.setSemanticsInnerNodesCase(true);
                this.setSemanticsUncertainCase(true);
                break;
            }
            case INNER_NODES_OPTIMISTIC: {
                this.btnInnerNodesCase[1].setSelection(true);
                this.btnSemanticsInnerNodesCase[1].setSelection(true);
                this.btnSemanticsUncertainCase[1].setSelection(true);
                this.setInnerNodesCase(true);
                this.setSemanticsInnerNodesCase(true);
                this.setSemanticsUncertainCase(true);
                break;
            }
            case INNER_NODES_AVERAGE: {
                this.btnInnerNodesCase[1].setSelection(true);
                this.btnSemanticsInnerNodesCase[1].setSelection(true);
                this.btnSemanticsUncertainCase[2].setSelection(true);
                this.setInnerNodesCase(true);
                this.setSemanticsInnerNodesCase(true);
                this.setSemanticsUncertainCase(true);
            }
        }
        if (this.function.isSymmetric()) {
            this.setInnerNodesCase(false);
            this.setSemanticsInnerNodesCase(false);
            this.setSemanticsUncertainCase(false);
        }
    }

    private void disableAllSettingsButtons() {
        int i = 0;
        while (i <= 1) {
            this.btnInnerNodesQuery[i].setSelection(false);
            this.btnSemanticsInnerNodesQuery[i].setSelection(false);
            this.btnInnerNodesCase[i].setSelection(false);
            this.btnSemanticsInnerNodesCase[i].setSelection(false);
            ++i;
        }
        i = 0;
        while (i <= 2) {
            this.btnSemanticsUncertainQuery[i].setSelection(false);
            this.btnSemanticsUncertainCase[i].setSelection(false);
            ++i;
        }
    }

    private void addDirtyOnChangeListeners() {
        this.btnSymmetry[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaxonomyEditor.this.function.setSymmetric(true);
                TaxonomyEditor.this.fillSettings();
            }
        });
        this.btnSymmetry[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaxonomyEditor.this.function.setSymmetric(false);
                TaxonomyEditor.this.fillSettings();
            }
        });
        this.btnInnerNodesQuery[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TaxonomyEditor.this.function.setQueryConfig(TaxonomyConfig.NO_INNERNODES);
                    TaxonomyEditor.this.fillSettings();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.btnInnerNodesQuery[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TaxonomyEditor.this.function.setQueryConfig(TaxonomyConfig.INNER_NODES_ANY);
                    TaxonomyEditor.this.fillSettings();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.btnSemanticsInnerNodesQuery[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TaxonomyEditor.this.function.setQueryConfig(TaxonomyConfig.INNER_NODES_ANY);
                    TaxonomyEditor.this.fillSettings();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.btnSemanticsInnerNodesQuery[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TaxonomyEditor.this.function.setQueryConfig(TaxonomyConfig.INNER_NODES_PESSIMISTIC);
                    TaxonomyEditor.this.fillSettings();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.btnSemanticsUncertainQuery[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TaxonomyEditor.this.function.setQueryConfig(TaxonomyConfig.INNER_NODES_PESSIMISTIC);
                    TaxonomyEditor.this.fillSettings();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.btnSemanticsUncertainQuery[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TaxonomyEditor.this.function.setQueryConfig(TaxonomyConfig.INNER_NODES_OPTIMISTIC);
                    TaxonomyEditor.this.fillSettings();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.btnSemanticsUncertainQuery[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TaxonomyEditor.this.function.setQueryConfig(TaxonomyConfig.INNER_NODES_AVERAGE);
                    TaxonomyEditor.this.fillSettings();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.btnInnerNodesCase[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TaxonomyEditor.this.function.setCaseConfig(TaxonomyConfig.NO_INNERNODES);
                    TaxonomyEditor.this.fillSettings();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.btnInnerNodesCase[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TaxonomyEditor.this.function.setCaseConfig(TaxonomyConfig.INNER_NODES_ANY);
                    TaxonomyEditor.this.fillSettings();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.btnSemanticsInnerNodesCase[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TaxonomyEditor.this.function.setCaseConfig(TaxonomyConfig.INNER_NODES_ANY);
                    TaxonomyEditor.this.fillSettings();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.btnSemanticsInnerNodesCase[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TaxonomyEditor.this.function.setCaseConfig(TaxonomyConfig.INNER_NODES_PESSIMISTIC);
                    TaxonomyEditor.this.fillSettings();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.btnSemanticsUncertainCase[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TaxonomyEditor.this.function.setCaseConfig(TaxonomyConfig.INNER_NODES_PESSIMISTIC);
                    TaxonomyEditor.this.fillSettings();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.btnSemanticsUncertainCase[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TaxonomyEditor.this.function.setCaseConfig(TaxonomyConfig.INNER_NODES_OPTIMISTIC);
                    TaxonomyEditor.this.fillSettings();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.btnSemanticsUncertainCase[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TaxonomyEditor.this.function.setCaseConfig(TaxonomyConfig.INNER_NODES_AVERAGE);
                    TaxonomyEditor.this.fillSettings();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    public void setFocus() {
    }

    @Override
    public void update(Observable o, Object arg) {
        this.trvTaxonomy.refresh();
    }

    public void dispose() {
        this.function.deleteObserver((Observer)this);
    }

    class TaxnomonyTreeLabelProvider
    extends LabelProvider {
        TaxnomonyTreeLabelProvider() {
        }

        public String getText(Object obj) {
            String columnText = null;
            if (obj instanceof SymbolDesc) {
                SymbolDesc desc = (SymbolDesc)obj;
                columnText = desc.getName();
            } else if (obj instanceof SymbolAttribute) {
                SymbolAttribute attribute = (SymbolAttribute)obj;
                columnText = attribute.getValue();
            }
            Similarity sim = (Similarity)TaxonomyEditor.this.function.getTaxonomy().getSimilarityMap().get((TaxonomyNode)obj);
            if (sim != null) {
                columnText = String.valueOf(columnText) + " [" + sim.getRoundedValue() + "]";
            }
            return columnText;
        }
    }

    class TaxonomyTreeContentProvider
    implements ITreeContentProvider {
        TaxonomyTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return TaxonomyEditor.this.function.getTaxonomy().getChildren((TaxonomyNode)parentElement).toArray();
        }

        public Object getParent(Object element) {
            return TaxonomyEditor.this.function.getTaxonomy().getParent((TaxonomyNode)element);
        }

        public boolean hasChildren(Object element) {
            List children = TaxonomyEditor.this.function.getTaxonomy().getChildren((TaxonomyNode)element);
            return children.size() > 0;
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

