/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.list;

import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.core.model.SimpleAttDesc;
import de.dfki.mycbr.core.similarity.AmalgamationFct;
import de.dfki.mycbr.core.similarity.ISimFct;
import de.dfki.mycbr.gui.function.editor.AmalgamationEditorInput;
import de.dfki.mycbr.gui.function.editor.FunctionEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class DeleteAction
extends Action
implements ActionFactory.IWorkbenchAction {
    TableViewer viewer;
    public static final String ID = "de.dfki.mycbr.gui.function.list.DeleteAction";

    public DeleteAction(TableViewer viewer) {
        this.viewer = viewer;
        this.setId(ID);
    }

    public void run() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IStructuredSelection ss = (IStructuredSelection)this.viewer.getSelection();
        Object o = ss.getFirstElement();
        if (o instanceof ISimFct) {
            ISimFct function = (ISimFct)o;
            SimpleAttDesc attribute = (SimpleAttDesc)function.getDesc();
            if (attribute.getSimFcts().size() <= 1) {
                MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)"You cannot delete the last similarity function.");
            } else if (MessageDialog.openConfirm((Shell)shell, (String)"Confirm Deletion", (String)"You are about to delete a similarity function. Are you sure?")) {
                IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    try {
                        FunctionEditorInput input;
                        IEditorInput editorInput = editorReference.getEditorInput();
                        if (editorInput instanceof FunctionEditorInput && (input = (FunctionEditorInput)editorInput).getFunction().equals(function)) {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorReference.getEditor(false), false);
                        }
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
                attribute.deleteSimFct(function);
                try {
                    if (!attribute.getOwner().getProject().getName().endsWith("_UNSAFED")) {
                        attribute.getOwner().getProject().setName(String.valueOf(attribute.getOwner().getProject().getName()) + "_UNSAFED");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else if (o instanceof AmalgamationFct) {
            AmalgamationFct function = (AmalgamationFct)o;
            Concept concept = function.getConcept();
            if (concept.getAvailableAmalgamFcts().size() <= 1) {
                MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)"You cannot delete the last amalgamation function.");
            } else if (MessageDialog.openConfirm((Shell)shell, (String)"Confirm Deletion", (String)"You are about to delete an amalgamation function. Are you sure?")) {
                IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n3];
                    try {
                        AmalgamationEditorInput input;
                        IEditorInput editorInput = editorReference.getEditorInput();
                        if (editorInput instanceof AmalgamationEditorInput && (input = (AmalgamationEditorInput)editorInput).getFunction().equals(function)) {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorReference.getEditor(false), false);
                        }
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    ++n3;
                }
                concept.deleteAmalgamFct(function);
                try {
                    if (!concept.getProject().getName().endsWith("_UNSAFED")) {
                        concept.getProject().setName(String.valueOf(concept.getProject().getName()) + "_UNSAFED");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.viewer.refresh();
    }

    public void dispose() {
    }
}

