/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.project.list;

import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.gui.attribute.editor.AttributeEditorInput;
import de.dfki.mycbr.gui.attribute.wizard.ConceptDescWizard;
import de.dfki.mycbr.gui.project.list.ProjectListView;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class NewConceptDescHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object obj;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        ProjectListView view = (ProjectListView)page.findView("de.dfki.mycbr.gui.project.list.ProjectListView");
        ISelection selection = view.getSite().getSelectionProvider().getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof Concept) {
            Concept concept = (Concept)obj;
            ConceptDescWizard wizard = new ConceptDescWizard(concept);
            WizardDialog wizardDialog = new WizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.create();
            wizardDialog.open();
            if (wizardDialog.getReturnCode() == 0) {
                try {
                    AttributeEditorInput input = new AttributeEditorInput((AttributeDesc)wizard.getConceptDesc());
                    page.openEditor((IEditorInput)input, "de.dfki.mycbr.gui.attribute.editor.AttributeFormEditor");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                IHandlerService handlerService = (IHandlerService)view.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler", null);
                }
                catch (Exception exception) {
                    throw new RuntimeException("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler not found");
                }
                try {
                    if (!concept.getProject().getName().endsWith("_UNSAFED")) {
                        concept.getProject().setName(String.valueOf(concept.getProject().getName()) + "_UNSAFED");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return null;
        }
        MessageDialog.openWarning((Shell)window.getShell(), (String)"Warning", (String)"Please select the concept which you want to add the attribute to.");
        return null;
    }
}

