/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.project.list;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.gui.concept.editor.ConceptEditorInput;
import de.dfki.mycbr.gui.project.list.ProjectListView;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class NewConceptHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IWorkbenchPage page = window.getActivePage();
        ProjectListView view = (ProjectListView)page.findView("de.dfki.mycbr.gui.project.list.ProjectListView");
        ISelection selection = view.getSite().getSelectionProvider().getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof Concept) {
                Concept concept = (Concept)obj;
                final Project project = concept.getProject();
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.isEmpty()) {
                            return "You must enter a concept name";
                        }
                        if (project.hasConceptWithID(newText).booleanValue()) {
                            return "There is another concept with that name.";
                        }
                        return null;
                    }
                };
                InputDialog inputDialog = new InputDialog(window.getShell(), "Enter a concept name", "Enter a concept name", "", validator);
                inputDialog.open();
                String conceptName = inputDialog.getValue();
                if (conceptName != null && !conceptName.isEmpty()) {
                    Concept newConcept = null;
                    try {
                        newConcept = new Concept(conceptName, project, concept);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ConceptEditorInput input = new ConceptEditorInput(newConcept);
                    try {
                        page.openEditor((IEditorInput)input, "de.dfki.mycbr.gui.concept.editor.ConceptFormEditor");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    IHandlerService handlerService = (IHandlerService)view.getSite().getService(IHandlerService.class);
                    try {
                        handlerService.executeCommand("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler", null);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("de.dfki.mycbr.gui.project.list.ProjectListRefreshHandler not found");
                    }
                    try {
                        if (!concept.getProject().getName().endsWith("_UNSAFED")) {
                            concept.getProject().setName(String.valueOf(concept.getProject().getName()) + "_UNSAFED");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            } else {
                MessageDialog.openWarning((Shell)window.getShell(), (String)"Warning", (String)"Please select a project or a concept which will function as the top concept for the newly created concept.");
            }
        }
        return null;
    }
}

