/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.casebase.list;

import de.dfki.mycbr.core.ICaseBase;
import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.core.casebase.Instance;
import de.dfki.mycbr.gui.casebase.list.AddCaseBaseAction;
import de.dfki.mycbr.gui.casebase.list.DeleteAction;
import de.dfki.mycbr.gui.casebase.list.FillThread;
import de.dfki.mycbr.gui.misc.MyCbrInterface;
import de.dfki.mycbr.gui.plugin.Activator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class CasebaseListView
extends ViewPart {
    public static final String ID = "de.dfki.mycbr.gui.casebase.list.CasebaseListView";
    private TableViewer tableViewer;
    private ICaseBase currentCaseBase = null;
    private FillThread thread;
    private DeleteAction deleteAction;
    private Project currentProject;
    ISelectionListener listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection sel) {
            if (!(sel instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection ss = (IStructuredSelection)sel;
            Object o = ss.getFirstElement();
            if (o instanceof Project) {
                CasebaseListView.this.currentProject = (Project)o;
                CasebaseListView.this.fillTable();
            }
        }
    };

    public Project getCurrentProject() {
        return this.currentProject;
    }

    public ICaseBase getCurrentCaseBase() {
        return this.currentCaseBase;
    }

    public void createPartControl(Composite parent) {
        this.tableViewer = new TableViewer(parent, 772);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AttributeTreeLabelProvider());
        this.getSite().getPage().addSelectionListener(this.listener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                Object o = ss.getFirstElement();
                if (o instanceof ICaseBase) {
                    IHandlerService handlerService = (IHandlerService)CasebaseListView.this.getSite().getService(IHandlerService.class);
                    try {
                        handlerService.executeCommand("de.dfki.mycbr.gui.casebase.editor.CallCasebaseEditor", null);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new RuntimeException("de.dfki.mycbr.gui.casebase.editor.CallCasebaseEditor not found");
                    }
                }
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        this.tableViewer.getTable().setMenu(menuManager.createContextMenu((Control)this.tableViewer.getTable()));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
        AddCaseBaseAction addCaseAction = new AddCaseBaseAction(this);
        addCaseAction.setText("Add Case Base");
        addCaseAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("caseAddIcon")));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)addCaseAction);
        this.deleteAction = new DeleteAction(this.tableViewer, this);
        this.deleteAction.setText("Delete");
        this.deleteAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE")));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.deleteAction);
        this.deleteAction.setEnabled(false);
    }

    public void setFocus() {
    }

    public void addCase(Instance caze) {
        this.tableViewer.add((Object)caze);
        try {
            if (!this.currentProject.getName().endsWith("_UNSAFED")) {
                this.currentProject.setName(String.valueOf(this.currentProject.getName()) + "_UNSAFED");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void clear() {
        this.currentCaseBase = null;
        this.tableViewer.getTable().clearAll();
    }

    public void refresh() {
        this.tableViewer.refresh();
        this.tableViewer.setSelection(this.tableViewer.getSelection());
    }

    public void refresh(String cbName) {
        this.refresh(cbName, false);
    }

    public void refresh(String cbName, boolean force) {
        if (this.currentCaseBase != null && this.currentCaseBase.equals(cbName) && !force) {
            return;
        }
        Project project = this.getCurrentProject();
        this.currentCaseBase = project.getCB(cbName);
        this.fillTable();
    }

    public void fillTable() {
        if (this.thread != null) {
            this.thread.done();
        }
        if (this.currentProject == null && MyCbrInterface.getInstance().getProjects().size() != 0) {
            this.currentProject = MyCbrInterface.getInstance().getProjects().get(0);
        }
        if (this.currentProject != null) {
            this.tableViewer.getTable().clearAll();
            this.thread = new FillThread(this.tableViewer, this.currentProject, this.deleteAction);
            this.thread.start();
            this.tableViewer.refresh();
        }
    }

    class AttributeTreeLabelProvider
    extends LabelProvider {
        AttributeTreeLabelProvider() {
        }

        public String getText(Object obj) {
            String columnText = "";
            if (obj instanceof ICaseBase) {
                ICaseBase case_ = (ICaseBase)obj;
                columnText = case_.getName();
            }
            return columnText;
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return Activator.getDefault().getImageRegistry().get("casebaseAddIcon");
        }
    }
}

