/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.casebaseexport.editor;

import de.dfki.mycbr.core.DefaultCaseBase;
import de.dfki.mycbr.core.ICaseBase;
import de.dfki.mycbr.core.casebase.Instance;
import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.core.retrieval.Retrieval;
import de.dfki.mycbr.core.retrieval.SequentialRetrieval;
import de.dfki.mycbr.core.similarity.Similarity;
import de.dfki.mycbr.gui.casebaseexport.editor.CasebaseExportInput;
import de.dfki.mycbr.gui.misc.ListUtil;
import de.dfki.mycbr.util.Pair;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;

public class CasebaseExport
extends EditorPart {
    public static final String ID = "de.dfki.mycbr.gui.casebaseexport.editor.CasebaseExport";
    private ICaseBase cb;
    private Concept concept;
    private Instance q;
    private List<Pair<Instance, Similarity>> results;
    private SequentialRetrieval sr;
    private ControlDecoration noCB;
    private TableViewer tblComparison;
    private int wholeColumns;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private Combo caseBaseBtn;
    private FileWriter fw = null;
    private PrintWriter pw = null;
    private int numberOfAttr;
    private Label numberOfAttrLabel;
    private Label numberOfCasesLabel;
    private Label attrLabel;
    private Button btnExport;
    private int min;
    private int max;
    private List<String> valueList = new ArrayList<String>();
    private Set<String> unique = new HashSet<String>(this.valueList);
    private int setCount;
    private int numberOfCases;
    private int check;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.concept = ((CasebaseExportInput)input).getConcept();
        this.setPartName("Case Base Export");
        Instance givenCase = ((CasebaseExportInput)input).getCase();
        Retrieval r = new Retrieval(this.concept, this.cb);
        if (givenCase != null) {
            try {
                this.q = this.concept.copyInstance(givenCase, String.valueOf(givenCase.getName()) + "_query");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.q = r.getQueryInstance();
        }
        this.sr = new SequentialRetrieval(this.concept.getProject(), r);
        this.results = new ArrayList<Pair<Instance, Similarity>>();
        this.numberOfAttr = this.concept.getAllAttributeDescs().values().size();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(final Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setText("Case Base Export");
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.form.getBody());
        Section sctCaseBase = this.toolkit.createSection(this.form.getBody(), 384);
        sctCaseBase.setText("Select a Case Base");
        GridDataFactory.fillDefaults().span(3, 1).align(4, 1).grab(true, false).applyTo((Control)sctCaseBase);
        this.caseBaseBtn = new Combo(sctCaseBase.getParent(), 2048);
        String[] items = new String[this.concept.getProject().getCaseBases().size()];
        this.caseBaseBtn.setItems(this.concept.getProject().getCaseBases().keySet().toArray(items));
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.noCB = new ControlDecoration((Control)this.caseBaseBtn, 131200);
        this.noCB.setDescriptionText("Please select a case base");
        this.noCB.setImage(fieldDecoration.getImage());
        this.btnExport = new Button(this.form.getBody(), 8);
        this.btnExport.setText("Export selected Case Base");
        this.btnExport.setVisible(false);
        this.caseBaseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String s = CasebaseExport.this.caseBaseBtn.getItem(CasebaseExport.this.caseBaseBtn.getSelectionIndex());
                CasebaseExport.this.cb = CasebaseExport.this.concept.getProject().getCB(s);
                if (CasebaseExport.this.cb != null) {
                    CasebaseExport.this.noCB.hide();
                    if (CasebaseExport.this.check != 1) {
                        Section sctStatistics = CasebaseExport.this.toolkit.createSection(CasebaseExport.this.form.getBody(), 384);
                        sctStatistics.setText("Statistics");
                        GridDataFactory.fillDefaults().span(3, 1).align(4, 1).grab(true, false).applyTo((Control)sctStatistics);
                        CasebaseExport.this.numberOfCasesLabel = new Label(CasebaseExport.this.form.getBody(), 16384);
                        CasebaseExport.this.numberOfCasesLabel.setText("");
                        CasebaseExport.this.numberOfCasesLabel.setLayoutData((Object)new GridData(768));
                        CasebaseExport.this.numberOfAttrLabel = new Label(CasebaseExport.this.form.getBody(), 16384);
                        CasebaseExport.this.numberOfAttrLabel.setText("Number of attributes: " + CasebaseExport.this.numberOfAttr);
                        CasebaseExport.this.numberOfAttrLabel.setLayoutData((Object)new GridData(768));
                        Label space = new Label(CasebaseExport.this.form.getBody(), 16384);
                        space.setText("");
                        space.setLayoutData((Object)new GridData(768));
                        List<AttributeDesc> sortedAttrDesc = ListUtil.sortAttributeDescs(CasebaseExport.this.concept.getAllAttributeDescs().values());
                        try {
                            CasebaseExport.this.results = CasebaseExport.this.sr.retrieveSorted((ICaseBase)((DefaultCaseBase)CasebaseExport.this.cb), CasebaseExport.this.q);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        int i = 1;
                        while (i <= CasebaseExport.this.numberOfAttr) {
                            CasebaseExport.this.attrLabel = new Label(CasebaseExport.this.form.getBody(), 16384);
                            CasebaseExport.this.wholeColumns = CasebaseExport.this.cb.getCases().size();
                            CasebaseExport.this.valueList.clear();
                            CasebaseExport.this.unique.clear();
                            int c = 1;
                            while (c <= CasebaseExport.this.wholeColumns) {
                                Pair result = (Pair)CasebaseExport.this.results.get(c - 1);
                                CasebaseExport.this.valueList.add(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString());
                                CasebaseExport.this.numberOfCases = CasebaseExport.this.valueList.size();
                                CasebaseExport.this.numberOfCasesLabel.setText("Number of cases: " + CasebaseExport.this.numberOfCases);
                                CasebaseExport.this.unique.add(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString());
                                CasebaseExport.this.setCount = CasebaseExport.this.unique.size();
                                CasebaseExport.this.attrLabel.setText(String.valueOf(sortedAttrDesc.get(i - 1).getName()) + ": " + "different values = " + CasebaseExport.this.setCount);
                                CasebaseExport.this.attrLabel.setLayoutData((Object)new GridData(768));
                                try {
                                    if (c == 1) {
                                        CasebaseExport.this.min = Integer.parseInt(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString());
                                        CasebaseExport.this.max = Integer.parseInt(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString());
                                    }
                                    if (Integer.parseInt(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString()) < CasebaseExport.this.min) {
                                        CasebaseExport.this.min = Integer.parseInt(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString());
                                    }
                                    if (Integer.parseInt(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString()) > CasebaseExport.this.max) {
                                        CasebaseExport.this.max = Integer.parseInt(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i - 1)).getValueAsString());
                                    }
                                    CasebaseExport.this.attrLabel.setText(String.valueOf(sortedAttrDesc.get(i - 1).getName()) + ": " + "min = " + CasebaseExport.this.min + " | max = " + CasebaseExport.this.max);
                                    CasebaseExport.this.attrLabel.setLayoutData((Object)new GridData(768));
                                }
                                catch (NumberFormatException numberFormatException) {}
                                ++c;
                            }
                            ++i;
                        }
                        CasebaseExport.this.btnExport.setVisible(true);
                        CasebaseExport.this.form.reflow(true);
                        CasebaseExport.this.check = 1;
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.btnExport.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                block14: {
                    if (CasebaseExport.this.cb != null) {
                        CasebaseExport.this.wholeColumns = CasebaseExport.this.cb.getCases().size();
                        try {
                            CasebaseExport.this.results = CasebaseExport.this.sr.retrieveSorted((ICaseBase)((DefaultCaseBase)CasebaseExport.this.cb), CasebaseExport.this.q);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        if (CasebaseExport.this.cb == null) {
                            return;
                        }
                        try {
                            FileDialog fd = new FileDialog(parent.getShell(), 8192);
                            fd.setText("Save");
                            fd.setFilterPath("C:/");
                            String[] filterExt = new String[]{"*.csv"};
                            fd.setFilterExtensions(filterExt);
                            String projectPath = fd.open();
                            if (projectPath == null) break block14;
                            try {
                                CasebaseExport.this.fw = new FileWriter(projectPath);
                                CasebaseExport.this.pw = new PrintWriter(CasebaseExport.this.fw);
                                List<AttributeDesc> sortedAttrDesc = ListUtil.sortAttributeDescs(CasebaseExport.this.concept.getAllAttributeDescs().values());
                                int i = 0;
                                while (i < CasebaseExport.this.numberOfAttr) {
                                    CasebaseExport.this.pw.print(sortedAttrDesc.get(i).getName());
                                    CasebaseExport.this.pw.print(";");
                                    ++i;
                                }
                                CasebaseExport.this.pw.println("");
                                int c = 1;
                                while (c <= CasebaseExport.this.wholeColumns) {
                                    int i2 = 0;
                                    while (i2 < CasebaseExport.this.numberOfAttr) {
                                        Pair result = (Pair)CasebaseExport.this.results.get(c - 1);
                                        CasebaseExport.this.pw.print(((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(i2)).getValueAsString());
                                        CasebaseExport.this.pw.print(";");
                                        ++i2;
                                    }
                                    CasebaseExport.this.pw.println("");
                                    ++c;
                                }
                            }
                            finally {
                                if (CasebaseExport.this.pw != null) {
                                    CasebaseExport.this.pw.flush();
                                    CasebaseExport.this.pw.close();
                                }
                                if (CasebaseExport.this.fw != null) {
                                    CasebaseExport.this.fw.close();
                                }
                            }
                        }
                        catch (Exception exception) {
                            MessageBox messageDialog = new MessageBox(CasebaseExport.this.form.getShell(), 1);
                            messageDialog.setText("Export failed");
                            messageDialog.setMessage("The process cannot access the file because it is being used by another process.");
                            messageDialog.open();
                        }
                    }
                }
            }
        });
        Section sctCaseBaseTable = this.toolkit.createSection(this.form.getBody(), 384);
        sctCaseBaseTable.setText("Preview Table");
        GridDataFactory.fillDefaults().span(3, 1).align(4, 1).grab(true, false).applyTo((Control)sctCaseBaseTable);
        Button btnPreview = new Button(sctCaseBaseTable.getParent(), 8);
        btnPreview.setText("Preview");
        btnPreview.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (CasebaseExport.this.cb == null) {
                    return;
                }
                if (CasebaseExport.this.cb != null) {
                    try {
                        CasebaseExport.this.results = CasebaseExport.this.sr.retrieveSorted((ICaseBase)((DefaultCaseBase)CasebaseExport.this.cb), CasebaseExport.this.q);
                        CasebaseExport.this.updateComparisonTable();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.tblComparison = new TableViewer(this.form.getBody(), 2816);
        this.tblComparison.getTable().setLinesVisible(true);
        this.tblComparison.getTable().setHeaderVisible(true);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).hint(-1, 300).applyTo((Control)this.tblComparison.getTable());
        this.form.reflow(true);
    }

    private void updateComparisonTable() {
        this.tblComparison.getTable().removeAll();
        List<AttributeDesc> sortedAttrDesc = ListUtil.sortAttributeDescs(this.concept.getAllAttributeDescs().values());
        int i = 0;
        while (i < this.numberOfAttr) {
            TableColumn column = new TableColumn(this.tblComparison.getTable(), 0);
            column.setText(sortedAttrDesc.get(i).getName());
            ++i;
        }
        this.wholeColumns = this.cb.getCases().size();
        int c = 1;
        while (c <= this.wholeColumns) {
            TableItem attr = new TableItem(this.tblComparison.getTable(), 0);
            Pair<Instance, Similarity> result = this.results.get(c - 1);
            int j = 0;
            while (j < this.numberOfAttr) {
                attr.setText(j, ((Instance)result.getFirst()).getAttForDesc(sortedAttrDesc.get(j)).getValueAsString());
                ++j;
            }
            ++c;
        }
        i = 0;
        while (i < this.numberOfAttr) {
            this.tblComparison.getTable().getColumn(i).pack();
            ++i;
        }
        this.tblComparison.getTable().update();
    }

    public void setFocus() {
    }
}

