/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.concept.editor;

import de.dfki.mycbr.core.casebase.Instance;
import de.dfki.mycbr.core.explanation.ConceptExplanation;
import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.gui.attribute.editor.AttributeFormEditor;
import de.dfki.mycbr.gui.concept.editor.ConceptFormEditor;
import de.dfki.mycbr.gui.instance.list.InstanceFormEditor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ExplanationPage
extends FormPage {
    public static final String ID = "de.dfki.mycbr.gui.concept.editor.ExplanationPage";
    private FormToolkit toolkit;
    private ScrolledForm form;
    private ConceptExplanation explanation;
    private String selectedValue;
    private Text txtDescription;
    private TableViewer tblLinks;

    public ExplanationPage(FormEditor editor) {
        super(editor, ID, "Concept Explanation");
        if (editor instanceof ConceptFormEditor) {
            Concept concept = ((ConceptFormEditor)editor).getConcept();
            this.explanation = concept.getProject().getExplanationManager().getExplanation(concept);
        } else if (editor instanceof AttributeFormEditor) {
            AttributeDesc attribute = ((AttributeFormEditor)editor).getAttribute();
            this.explanation = attribute.getOwner().getProject().getExplanationManager().getExplanation(attribute);
        } else if (editor instanceof InstanceFormEditor) {
            Instance i = ((InstanceFormEditor)editor).getInstance();
            this.explanation = i.getConcept().getProject().getExplanationManager().getExplanation(i);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.toolkit = managedForm.getToolkit();
        this.form = managedForm.getForm();
        this.form.setText("Concept Explanation");
        this.form.setExpandHorizontal(true);
        this.form.setExpandVertical(true);
        this.createUi();
        this.fillModel();
        this.addUpdateOnChangeListeners();
        this.form.reflow(true);
    }

    private void createUi() {
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(this.form.getBody());
        Label lblDescription = this.toolkit.createLabel(this.form.getBody(), "Short description:");
        this.txtDescription = this.toolkit.createText(this.form.getBody(), "", 2626);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)lblDescription);
        GridDataFactory.fillDefaults().align(4, 128).hint(-1, 200).grab(true, false).span(2, 1).applyTo((Control)this.txtDescription);
        Label lblLinks = this.toolkit.createLabel(this.form.getBody(), "Links:");
        this.tblLinks = new TableViewer(this.form.getBody(), 68356);
        this.tblLinks.getTable().setLinesVisible(true);
        this.tblLinks.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)lblLinks);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(300, 200).applyTo((Control)this.tblLinks.getTable());
        Composite cmpButtonGroup = this.toolkit.createComposite(this.form.getBody());
        FillLayout cmpButtonGroupLayout = new FillLayout(512);
        cmpButtonGroup.setLayout((Layout)cmpButtonGroupLayout);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)cmpButtonGroup);
        Button btnAdd = new Button(cmpButtonGroup, 8);
        btnAdd.setText("Add");
        Button btnRemove = new Button(cmpButtonGroup, 8);
        btnRemove.setText("Remove");
        this.tblLinks.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                ExplanationPage.this.selectedValue = (String)ss.getFirstElement();
            }
        });
        final Shell shell = this.form.getShell();
        btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String newValue;
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.isEmpty()) {
                            return "You must enter a link";
                        }
                        return null;
                    }
                };
                do {
                    InputDialog inputDialog = new InputDialog(shell, "Add link", "Please a valid link", "", validator);
                    inputDialog.open();
                    newValue = inputDialog.getValue();
                    if (newValue == null || newValue.isEmpty()) continue;
                    ExplanationPage.this.explanation.addLink(newValue);
                    ExplanationPage.this.tblLinks.setInput((Object)ExplanationPage.this.explanation.getLinks());
                } while (newValue != null && !newValue.isEmpty());
            }
        });
        btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (ExplanationPage.this.selectedValue != null) {
                    ExplanationPage.this.explanation.removeLink(ExplanationPage.this.selectedValue);
                    ExplanationPage.this.tblLinks.setInput((Object)ExplanationPage.this.explanation.getLinks());
                }
            }
        });
    }

    private void fillModel() {
        this.txtDescription.setText(this.explanation.getDescription());
        this.tblLinks.setInput((Object)this.explanation.getLinks());
    }

    private void addUpdateOnChangeListeners() {
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExplanationPage.this.explanation.setDescription(ExplanationPage.this.txtDescription.getText());
            }
        });
    }

    public boolean isDirty() {
        return false;
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        super.dispose();
    }
}

