/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.editor;

import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.similarity.AmalgamationFct;
import de.dfki.mycbr.core.similarity.ISimFct;
import de.dfki.mycbr.core.similarity.config.AmalgamationConfig;
import de.dfki.mycbr.gui.function.editor.AmalgamationEditingSupport;
import de.dfki.mycbr.gui.function.editor.AmalgamationEditorInput;
import de.dfki.mycbr.gui.misc.ListUtil;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class AmalgamationEditor
extends EditorPart
implements Observer {
    public static final String ID = "de.dfki.mycbr.gui.function.editor.AmalgamationEditor";
    private AmalgamationFct function;
    private TableViewer viewer;
    private Button[] btnType;
    private String ATTRIBUTE = "Attribute";
    private String DISCRIMINANT = "Discriminant";
    private String WEIGHT = "Weight";
    private String SMF = "SMF";

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.function = ((AmalgamationEditorInput)input).getFunction();
        this.setPartName(this.function.getName());
        this.function.getConcept().addObserver((Observer)this);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.createUi(parent);
        this.fillModel();
    }

    private void createUi(Composite parent) {
        Label lblType = new Label(parent, 0);
        lblType.setText("Type");
        this.btnType = new Button[4];
        Composite cmpTypeGroup = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout(256);
        cmpTypeGroup.setLayout((Layout)rowLayout);
        this.btnType[0] = new Button(cmpTypeGroup, 16);
        this.btnType[0].setText("Weighted Sum");
        this.btnType[1] = new Button(cmpTypeGroup, 16);
        this.btnType[1].setText("Euclidean");
        this.btnType[2] = new Button(cmpTypeGroup, 16);
        this.btnType[2].setText("Minimum");
        this.btnType[3] = new Button(cmpTypeGroup, 16);
        this.btnType[3].setText("Maximum");
        this.btnType[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AmalgamationEditor.this.function.setType(AmalgamationConfig.WEIGHTED_SUM);
            }
        });
        this.btnType[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AmalgamationEditor.this.function.setType(AmalgamationConfig.EUCLIDEAN);
            }
        });
        this.btnType[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AmalgamationEditor.this.function.setType(AmalgamationConfig.MINIMUM);
            }
        });
        this.btnType[3].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AmalgamationEditor.this.function.setType(AmalgamationConfig.MAXIMUM);
            }
        });
        this.viewer = new TableViewer(parent, 68356);
        this.createColumns(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new AmalgamationContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AmalgamationLabelProvider());
        this.viewer.setInput(ListUtil.sortAttributeDescs(this.function.getConcept().getAllAttributeDescs().values()));
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(3, 1).applyTo((Control)this.viewer.getTable());
    }

    private void createColumns(TableViewer viewer) {
        String[] titles = new String[]{this.ATTRIBUTE, this.DISCRIMINANT, this.WEIGHT, this.SMF};
        int[] bounds = new int[]{100, 100, 100, 100};
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn column = new TableViewerColumn(viewer, 0);
            column.getColumn().setText(titles[i]);
            column.getColumn().setWidth(bounds[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(false);
            column.setEditingSupport((EditingSupport)new AmalgamationEditingSupport((ColumnViewer)viewer, i, this.function));
            ++i;
        }
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private void fillModel() {
        switch (this.function.getType()) {
            case WEIGHTED_SUM: {
                this.btnType[0].setSelection(true);
                break;
            }
            case EUCLIDEAN: {
                this.btnType[1].setSelection(true);
                break;
            }
            case MINIMUM: {
                this.btnType[2].setSelection(true);
                break;
            }
            case MAXIMUM: {
                this.btnType[3].setSelection(true);
            }
        }
    }

    public void setFocus() {
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!this.viewer.getTable().isDisposed()) {
            this.viewer.setInput(ListUtil.sortAttributeDescs(this.function.getConcept().getAllAttributeDescs().values()));
            this.viewer.refresh();
        }
    }

    class AmalgamationContentProvider
    implements IStructuredContentProvider {
        AmalgamationContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Collection elements = (Collection)inputElement;
            return elements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class AmalgamationLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        AmalgamationLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            AttributeDesc attrDesc = (AttributeDesc)element;
            Object activeFct = AmalgamationEditor.this.function.getActiveFct(attrDesc);
            switch (columnIndex) {
                case 0: {
                    return attrDesc.getName();
                }
                case 1: {
                    return AmalgamationEditor.this.function.isActive(attrDesc) != false ? "true" : "false";
                }
                case 2: {
                    return AmalgamationEditor.this.function.getWeight(attrDesc).toString();
                }
                case 3: {
                    if (activeFct instanceof AmalgamationFct) {
                        return ((AmalgamationFct)AmalgamationEditor.this.function.getActiveFct(attrDesc)).getName();
                    }
                    return ((ISimFct)AmalgamationEditor.this.function.getActiveFct(attrDesc)).getName();
                }
            }
            throw new RuntimeException("Should not happen");
        }
    }
}

