/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.editor;

import de.dfki.mycbr.core.casebase.SymbolAttribute;
import de.dfki.mycbr.core.similarity.IntegerFct;
import de.dfki.mycbr.core.similarity.OrderedSymbolFct;
import de.dfki.mycbr.core.similarity.config.DistanceConfig;
import de.dfki.mycbr.core.similarity.config.NumberConfig;
import de.dfki.mycbr.gui.function.editor.OrderedEditorInput;
import de.dfki.mycbr.gui.function.editor.SetSimilarityWizard;
import de.dfki.mycbr.gui.function.editor.function2d.IntegerFunction2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.function.Function2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class OrderedEditor
extends EditorPart {
    public static final String ID = "de.dfki.mycbr.gui.function.editor.OrderedEditor";
    private OrderedSymbolFct function;
    private IntegerFct internalFct;
    private Button[] btnSymmetry;
    private Button[] btnDistanceFct;
    private Composite cmpModeGroup;
    private Button[] btnModeLeft;
    private Button[] btnModeRight;
    private Text[] txtModeLeft;
    private Text[] txtModeRight;
    private ChartComposite cmpChart;
    private TableViewer tblOrder;
    private Button btnCyclic;
    private double functionParameterL;
    private double functionParameterR;
    private NumberConfig functionTypeL;
    private NumberConfig functionTypeR;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.function = ((OrderedEditorInput)input).getFunction();
        this.internalFct = this.function.getInternalFunction();
        this.setPartName(this.function.getName());
        this.functionTypeL = this.internalFct.getFunctionTypeL();
        this.functionTypeR = this.internalFct.getFunctionTypeR();
        this.functionParameterL = this.internalFct.getFunctionParameterL();
        this.functionParameterR = this.internalFct.getFunctionParameterR();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.createUi(parent);
        this.addDirtyOnChangeListeners();
    }

    private void createUi(Composite parent) {
        Label lblSymmetry = new Label(parent, 0);
        lblSymmetry.setText("Symmetry");
        Composite cmpSymmetryGroup = new Composite(parent, 0);
        cmpSymmetryGroup.setLayout((Layout)new FillLayout(256));
        this.btnSymmetry = new Button[2];
        this.btnSymmetry[0] = new Button(cmpSymmetryGroup, 16);
        this.btnSymmetry[0].setText("symmetric");
        this.btnSymmetry[1] = new Button(cmpSymmetryGroup, 16);
        this.btnSymmetry[1].setText("asymmetric");
        this.btnSymmetry[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrderedEditor.this.setSymmetric();
                OrderedEditor.this.redrawChart();
            }
        });
        this.btnSymmetry[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrderedEditor.this.setAsymmetric();
                OrderedEditor.this.redrawChart();
            }
        });
        Label lblDistanceFct = new Label(parent, 0);
        lblDistanceFct.setText("Distance Function");
        Composite cmpDistanceGroup = new Composite(parent, 0);
        cmpDistanceGroup.setLayout((Layout)new FillLayout(256));
        this.btnDistanceFct = new Button[2];
        this.btnDistanceFct[0] = new Button(cmpDistanceGroup, 16);
        this.btnDistanceFct[0].setText("difference");
        this.btnDistanceFct[1] = new Button(cmpDistanceGroup, 16);
        this.btnDistanceFct[1].setText("quotient");
        this.btnDistanceFct[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrderedEditor.this.internalFct.setDistanceFct(DistanceConfig.DIFFERENCE);
                OrderedEditor.this.redrawChart();
            }
        });
        this.btnDistanceFct[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrderedEditor.this.internalFct.setDistanceFct(DistanceConfig.QUOTIENT);
                OrderedEditor.this.redrawChart();
            }
        });
        this.createModeButtons(parent);
        this.fillModel();
        this.createModeButtonCallbacks();
        this.btnCyclic = new Button(parent, 32);
        this.btnCyclic.setText("cyclic");
        this.btnCyclic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                OrderedEditor.this.function.setCyclic(b.getSelection());
                OrderedEditor.this.redrawChart();
            }
        });
        this.tblOrder = new TableViewer(parent, 68356);
        this.tblOrder.getTable().setLinesVisible(true);
        this.tblOrder.getTable().setHeaderVisible(true);
        TableViewerColumn symbolColumn = new TableViewerColumn(this.tblOrder, 0);
        symbolColumn.getColumn().setText("Symbol");
        TableViewerColumn valueColumn = new TableViewerColumn(this.tblOrder, 0);
        valueColumn.getColumn().setText("Value");
        valueColumn.setEditingSupport((EditingSupport)new OrderTableEditingSupport((ColumnViewer)this.tblOrder));
        this.tblOrder.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                HashMap order = (HashMap)inputElement;
                ArrayList result = new ArrayList();
                for (Map.Entry e : order.entrySet()) {
                    result.add(e);
                }
                return result.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tblOrder.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Integer value1 = (Integer)((Map.Entry)e1).getValue();
                Integer value2 = (Integer)((Map.Entry)e2).getValue();
                return value1.compareTo(value2);
            }
        });
        this.tblOrder.setLabelProvider((IBaseLabelProvider)new OrderTableLabelProvider());
        this.tblOrder.setInput((Object)this.function.getOrder());
        symbolColumn.getColumn().pack();
        valueColumn.getColumn().pack();
        this.cmpChart = new ChartComposite(parent, 0);
        this.redrawChart();
        final Shell shell = parent.getShell();
        if (this.function.getDesc().isMultiple()) {
            Button btnSetSimilarity = new Button(parent, 8);
            btnSetSimilarity.setText("Configure set similarity");
            btnSetSimilarity.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SetSimilarityWizard wizard = new SetSimilarityWizard(OrderedEditor.this.function.getMultipleConfig());
                    WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard){

                        public void updateButtons() {
                            super.updateButtons();
                            this.getButton(1).setEnabled(false);
                        }
                    };
                    wizardDialog.create();
                    wizardDialog.open();
                }
            });
        }
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(3, 1).applyTo((Control)this.cmpModeGroup);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)cmpSymmetryGroup);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)cmpDistanceGroup);
        GridDataFactory.fillDefaults().align(4, 128).span(3, 1).applyTo((Control)this.btnCyclic);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)this.tblOrder.getTable());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.cmpChart);
    }

    private void createModeButtons(Composite parent) {
        Text t;
        this.btnModeLeft = new Button[4];
        this.txtModeLeft = new Text[4];
        this.btnModeRight = new Button[4];
        this.txtModeRight = new Text[4];
        this.cmpModeGroup = new Composite(parent, 0);
        GridLayout cmpModeLayout = new GridLayout(2, true);
        this.cmpModeGroup.setLayout((Layout)cmpModeLayout);
        Composite cmpLeftModeGroup = new Composite(this.cmpModeGroup, 0);
        GridLayout cmpLeftModeLayout = new GridLayout(2, true);
        cmpLeftModeGroup.setLayout((Layout)cmpLeftModeLayout);
        this.btnModeLeft[0] = new Button(cmpLeftModeGroup, 16);
        this.btnModeLeft[0].setText("Constant");
        this.txtModeLeft[0] = new Text(cmpLeftModeGroup, 2048);
        this.btnModeLeft[1] = new Button(cmpLeftModeGroup, 16);
        this.btnModeLeft[1].setText("Step at");
        this.txtModeLeft[1] = new Text(cmpLeftModeGroup, 2048);
        this.btnModeLeft[2] = new Button(cmpLeftModeGroup, 16);
        this.btnModeLeft[2].setText("Polynomial with");
        this.txtModeLeft[2] = new Text(cmpLeftModeGroup, 2048);
        this.btnModeLeft[3] = new Button(cmpLeftModeGroup, 16);
        this.btnModeLeft[3].setText("Smooth-Step at");
        this.txtModeLeft[3] = new Text(cmpLeftModeGroup, 2048);
        Composite cmpRightModeGroup = new Composite(this.cmpModeGroup, 0);
        GridLayout cmpRightModeLayout = new GridLayout(2, true);
        cmpRightModeGroup.setLayout((Layout)cmpRightModeLayout);
        this.btnModeRight[0] = new Button(cmpRightModeGroup, 16);
        this.btnModeRight[0].setText("Constant");
        this.txtModeRight[0] = new Text(cmpRightModeGroup, 2048);
        this.btnModeRight[1] = new Button(cmpRightModeGroup, 16);
        this.btnModeRight[1].setText("Step at");
        this.txtModeRight[1] = new Text(cmpRightModeGroup, 2048);
        this.btnModeRight[2] = new Button(cmpRightModeGroup, 16);
        this.btnModeRight[2].setText("Polynomial with");
        this.txtModeRight[2] = new Text(cmpRightModeGroup, 2048);
        this.btnModeRight[3] = new Button(cmpRightModeGroup, 16);
        this.btnModeRight[3].setText("Smooth-Step at");
        this.txtModeRight[3] = new Text(cmpRightModeGroup, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Text[] textArray = this.txtModeLeft;
        int n = this.txtModeLeft.length;
        int n2 = 0;
        while (n2 < n) {
            t = textArray[n2];
            t.setLayoutData((Object)gridData);
            t.setEnabled(false);
            ++n2;
        }
        textArray = this.txtModeRight;
        n = this.txtModeRight.length;
        n2 = 0;
        while (n2 < n) {
            t = textArray[n2];
            t.setLayoutData((Object)gridData);
            t.setEnabled(false);
            ++n2;
        }
    }

    private void createModeButtonCallbacks() {
        this.btnModeLeft[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    OrderedEditor.this.enableLeftTextBox(0);
                    OrderedEditor.this.functionTypeL = NumberConfig.CONSTANT;
                    OrderedEditor.this.functionParameterL = Double.valueOf(OrderedEditor.this.txtModeLeft[0].getText());
                    OrderedEditor.this.internalFct.setFunctionTypeL(OrderedEditor.this.functionTypeL);
                    OrderedEditor.this.internalFct.setFunctionParameterL(OrderedEditor.this.functionParameterL);
                    OrderedEditor.this.redrawChart();
                }
            }
        });
        this.btnModeLeft[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    OrderedEditor.this.enableLeftTextBox(1);
                    OrderedEditor.this.functionTypeL = NumberConfig.STEP_AT;
                    OrderedEditor.this.functionParameterL = Double.valueOf(OrderedEditor.this.txtModeLeft[1].getText());
                    OrderedEditor.this.internalFct.setFunctionTypeL(OrderedEditor.this.functionTypeL);
                    OrderedEditor.this.internalFct.setFunctionParameterL(OrderedEditor.this.functionParameterL);
                    OrderedEditor.this.redrawChart();
                }
            }
        });
        this.btnModeLeft[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    OrderedEditor.this.enableLeftTextBox(2);
                    OrderedEditor.this.functionTypeL = NumberConfig.POLYNOMIAL_WITH;
                    OrderedEditor.this.functionParameterL = Double.valueOf(OrderedEditor.this.txtModeLeft[2].getText());
                    OrderedEditor.this.internalFct.setFunctionTypeL(OrderedEditor.this.functionTypeL);
                    OrderedEditor.this.internalFct.setFunctionParameterL(OrderedEditor.this.functionParameterL);
                    OrderedEditor.this.redrawChart();
                }
            }
        });
        this.btnModeLeft[3].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    OrderedEditor.this.enableLeftTextBox(3);
                    OrderedEditor.this.functionTypeL = NumberConfig.SMOOTH_STEP_AT;
                    OrderedEditor.this.functionParameterL = Double.valueOf(OrderedEditor.this.txtModeLeft[3].getText());
                    OrderedEditor.this.internalFct.setFunctionTypeL(OrderedEditor.this.functionTypeL);
                    OrderedEditor.this.internalFct.setFunctionParameterL(OrderedEditor.this.functionParameterL);
                    OrderedEditor.this.redrawChart();
                }
            }
        });
        this.btnModeRight[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    OrderedEditor.this.enableRightTextBox(0);
                    OrderedEditor.this.functionTypeR = NumberConfig.CONSTANT;
                    OrderedEditor.this.functionParameterR = Double.valueOf(OrderedEditor.this.txtModeRight[0].getText());
                    OrderedEditor.this.internalFct.setFunctionTypeR(OrderedEditor.this.functionTypeR);
                    OrderedEditor.this.internalFct.setFunctionParameterR(OrderedEditor.this.functionParameterR);
                    OrderedEditor.this.redrawChart();
                }
            }
        });
        this.btnModeRight[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    OrderedEditor.this.enableRightTextBox(1);
                    OrderedEditor.this.functionTypeR = NumberConfig.STEP_AT;
                    OrderedEditor.this.functionParameterR = Double.valueOf(OrderedEditor.this.txtModeRight[1].getText());
                    OrderedEditor.this.internalFct.setFunctionTypeR(OrderedEditor.this.functionTypeR);
                    OrderedEditor.this.internalFct.setFunctionParameterR(OrderedEditor.this.functionParameterR);
                    OrderedEditor.this.redrawChart();
                }
            }
        });
        this.btnModeRight[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    OrderedEditor.this.enableRightTextBox(2);
                    OrderedEditor.this.functionTypeR = NumberConfig.POLYNOMIAL_WITH;
                    OrderedEditor.this.functionParameterR = Double.valueOf(OrderedEditor.this.txtModeRight[2].getText());
                    OrderedEditor.this.internalFct.setFunctionTypeR(OrderedEditor.this.functionTypeR);
                    OrderedEditor.this.internalFct.setFunctionParameterR(OrderedEditor.this.functionParameterR);
                    OrderedEditor.this.redrawChart();
                }
            }
        });
        this.btnModeRight[3].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    OrderedEditor.this.enableRightTextBox(3);
                    OrderedEditor.this.functionTypeR = NumberConfig.SMOOTH_STEP_AT;
                    OrderedEditor.this.functionParameterR = Double.valueOf(OrderedEditor.this.txtModeRight[3].getText());
                    OrderedEditor.this.internalFct.setFunctionTypeR(OrderedEditor.this.functionTypeR);
                    OrderedEditor.this.internalFct.setFunctionParameterR(OrderedEditor.this.functionParameterR);
                    OrderedEditor.this.redrawChart();
                }
            }
        });
        ModifyListener modifyListenerLeft = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OrderedEditor.this.functionParameterL = Double.valueOf(((Text)e.widget).getText());
                OrderedEditor.this.internalFct.setFunctionParameterL(OrderedEditor.this.functionParameterL);
                OrderedEditor.this.redrawChart();
            }
        };
        Text[] textArray = this.txtModeLeft;
        int n = this.txtModeLeft.length;
        int n2 = 0;
        while (n2 < n) {
            Text t = textArray[n2];
            t.addModifyListener(modifyListenerLeft);
            ++n2;
        }
        ModifyListener modifyListenerRight = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OrderedEditor.this.functionParameterR = Double.valueOf(((Text)e.widget).getText());
                OrderedEditor.this.internalFct.setFunctionParameterR(OrderedEditor.this.functionParameterR);
                OrderedEditor.this.redrawChart();
            }
        };
        Text[] textArray2 = this.txtModeRight;
        int n3 = this.txtModeRight.length;
        n = 0;
        while (n < n3) {
            Text t = textArray2[n];
            t.addModifyListener(modifyListenerRight);
            ++n;
        }
    }

    private void enableLeftTextBox(int i) {
        Text[] textArray = this.txtModeLeft;
        int n = this.txtModeLeft.length;
        int n2 = 0;
        while (n2 < n) {
            Text t = textArray[n2];
            t.setEnabled(false);
            ++n2;
        }
        this.txtModeLeft[i].setEnabled(true);
    }

    private void enableRightTextBox(int i) {
        Text[] textArray = this.txtModeRight;
        int n = this.txtModeRight.length;
        int n2 = 0;
        while (n2 < n) {
            Text t = textArray[n2];
            t.setEnabled(false);
            ++n2;
        }
        this.txtModeRight[i].setEnabled(true);
    }

    private void fillModel() {
        if (this.function.isSymmetric()) {
            this.btnSymmetry[0].setSelection(true);
            this.setSymmetric();
        } else {
            this.btnSymmetry[1].setSelection(true);
            this.setAsymmetric();
        }
        if (this.internalFct.getDistanceFct() == DistanceConfig.DIFFERENCE) {
            this.btnDistanceFct[0].setSelection(true);
        } else {
            this.btnDistanceFct[1].setSelection(true);
        }
        this.fillTextWithSensibleDefaults();
        switch (this.functionTypeL) {
            case CONSTANT: {
                this.txtModeLeft[0].setEnabled(true);
                this.btnModeLeft[0].setSelection(true);
                this.txtModeLeft[0].setText(String.valueOf(this.internalFct.getFunctionParameterL()));
                break;
            }
            case STEP_AT: {
                this.txtModeLeft[1].setEnabled(true);
                this.btnModeLeft[1].setSelection(true);
                this.txtModeLeft[1].setText(String.valueOf(this.internalFct.getFunctionParameterL()));
                break;
            }
            case POLYNOMIAL_WITH: {
                this.txtModeLeft[2].setEnabled(true);
                this.btnModeLeft[2].setSelection(true);
                this.txtModeLeft[2].setText(String.valueOf(this.internalFct.getFunctionParameterL()));
                break;
            }
            case SMOOTH_STEP_AT: {
                this.txtModeLeft[3].setEnabled(true);
                this.btnModeLeft[3].setSelection(true);
                this.txtModeLeft[3].setText(String.valueOf(this.internalFct.getFunctionParameterL()));
            }
        }
        switch (this.functionTypeR) {
            case CONSTANT: {
                this.txtModeRight[0].setText(String.valueOf(this.internalFct.getFunctionParameterR()));
                break;
            }
            case STEP_AT: {
                this.txtModeRight[1].setText(String.valueOf(this.internalFct.getFunctionParameterR()));
                break;
            }
            case POLYNOMIAL_WITH: {
                this.txtModeRight[2].setText(String.valueOf(this.internalFct.getFunctionParameterR()));
                break;
            }
            case SMOOTH_STEP_AT: {
                this.txtModeRight[3].setText(String.valueOf(this.internalFct.getFunctionParameterR()));
            }
        }
    }

    private void fillTextWithSensibleDefaults() {
        Double halfDifference = this.internalFct.getDiff() / 2.0;
        this.txtModeLeft[0].setText("0.5");
        this.txtModeRight[0].setText("0.5");
        this.txtModeLeft[1].setText(halfDifference.toString());
        this.txtModeRight[1].setText(halfDifference.toString());
        this.txtModeLeft[2].setText("1.0");
        this.txtModeRight[2].setText("1.0");
        this.txtModeLeft[3].setText(halfDifference.toString());
        this.txtModeRight[3].setText(halfDifference.toString());
    }

    private void setSymmetric() {
        this.function.setSymmetric(true);
        Button[] buttonArray = this.btnModeRight;
        int n = this.btnModeRight.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            b.setEnabled(false);
            ++n2;
        }
        buttonArray = this.txtModeRight;
        n = this.txtModeRight.length;
        n2 = 0;
        while (n2 < n) {
            Button t = buttonArray[n2];
            t.setEnabled(false);
            ++n2;
        }
    }

    private void setAsymmetric() {
        this.function.setSymmetric(false);
        switch (this.functionTypeR) {
            case CONSTANT: {
                this.txtModeRight[0].setEnabled(true);
                this.btnModeRight[0].setSelection(true);
                break;
            }
            case STEP_AT: {
                this.txtModeRight[1].setEnabled(true);
                this.btnModeRight[1].setSelection(true);
                break;
            }
            case POLYNOMIAL_WITH: {
                this.txtModeRight[2].setEnabled(true);
                this.btnModeRight[2].setSelection(true);
                break;
            }
            case SMOOTH_STEP_AT: {
                this.txtModeRight[3].setEnabled(true);
                this.btnModeRight[3].setSelection(true);
            }
        }
        Button[] buttonArray = this.btnModeRight;
        int n = this.btnModeRight.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            b.setEnabled(true);
            ++n2;
        }
    }

    private void redrawChart() {
        XYDataset dataset = this.internalFct.getDistanceFct() == DistanceConfig.QUOTIENT ? DatasetUtilities.sampleFunction2D((Function2D)new IntegerFunction2D(this.internalFct), (double)0.0, (double)(this.internalFct.getMax() / this.internalFct.getMin()), (int)100, (Comparable)((Object)"Function")) : DatasetUtilities.sampleFunction2D((Function2D)new IntegerFunction2D(this.internalFct), (double)(-this.internalFct.getDiff()), (double)this.internalFct.getDiff(), (int)100, (Comparable)((Object)"Function"));
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)"", (String)"", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setRange(-0.01, 1.0);
        plot.setOutlineVisible(false);
        ValueMarker yAxisMarker = this.internalFct.getDistanceFct() == DistanceConfig.QUOTIENT ? new ValueMarker(1.0) : new ValueMarker(0.0);
        yAxisMarker.setPaint((Paint)Color.black);
        yAxisMarker.setStroke((Stroke)new BasicStroke(2.0f, 0, 2));
        chart.getXYPlot().addDomainMarker((Marker)yAxisMarker);
        this.cmpChart.setChart(chart);
        chart.fireChartChanged();
        try {
            if (!this.function.getProject().getName().endsWith("_UNSAFED")) {
                this.function.getProject().setName(String.valueOf(this.function.getProject().getName()) + "_UNSAFED");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addDirtyOnChangeListeners() {
    }

    public void setFocus() {
    }

    class OrderTableEditingSupport
    extends EditingSupport {
        CellEditor editor;

        public OrderTableEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            Map.Entry e = (Map.Entry)element;
            return ((Integer)e.getValue()).toString();
        }

        protected void setValue(Object element, Object value) {
            Map.Entry e = (Map.Entry)element;
            try {
                OrderedEditor.this.function.setOrderIndexOf((SymbolAttribute)e.getKey(), Integer.valueOf(String.valueOf(value)).intValue());
            }
            catch (NumberFormatException e1) {
                e1.printStackTrace();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.getViewer().refresh();
            OrderedEditor.this.redrawChart();
        }
    }

    class OrderTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        OrderTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Map.Entry e = (Map.Entry)element;
            switch (columnIndex) {
                case 0: {
                    return ((SymbolAttribute)e.getKey()).getName();
                }
                case 1: {
                    return ((Integer)e.getValue()).toString();
                }
            }
            throw new RuntimeException("Should not happen");
        }
    }
}

