/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.wizard;

import de.dfki.mycbr.core.model.BooleanDesc;
import de.dfki.mycbr.core.model.DoubleDesc;
import de.dfki.mycbr.core.model.FloatDesc;
import de.dfki.mycbr.core.model.IntegerDesc;
import de.dfki.mycbr.core.model.IntervalDesc;
import de.dfki.mycbr.core.model.SimpleAttDesc;
import de.dfki.mycbr.core.model.StringDesc;
import de.dfki.mycbr.core.model.SymbolDesc;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class FunctionTypePage
extends WizardPage {
    public static final String PAGE_NAME = "Function type";
    private SimpleAttDesc attrDesc;
    private Text txtName;
    private ComboViewer cvType;
    private List<String> functionTypes;

    public FunctionTypePage(SimpleAttDesc attrDesc) {
        super(PAGE_NAME, "Create a similarity function", null);
        this.setDescription("Specify the name and type of the new similarity function.");
        this.attrDesc = attrDesc;
        this.initFunctionTypes();
    }

    private void initFunctionTypes() {
        this.functionTypes = new ArrayList<String>();
        if (this.attrDesc instanceof IntegerDesc) {
            this.functionTypes.add("IntegerFct");
            this.functionTypes.add("AdvancedIntegerFct");
        } else if (this.attrDesc instanceof DoubleDesc) {
            this.functionTypes.add("DoubleFct");
            this.functionTypes.add("AdvancedDoubleFct");
        } else if (this.attrDesc instanceof FloatDesc) {
            this.functionTypes.add("FloatFct");
            this.functionTypes.add("AdvancedFloatFct");
        } else if (!(this.attrDesc instanceof StringDesc)) {
            if (this.attrDesc instanceof SymbolDesc) {
                this.functionTypes.add("SymbolFct");
                this.functionTypes.add("OrderedSymbolFct");
                this.functionTypes.add("TaxonomyFct");
            } else if (!(this.attrDesc instanceof BooleanDesc)) {
                boolean cfr_ignored_0 = this.attrDesc instanceof IntervalDesc;
            }
        }
    }

    public void createControl(Composite parent) {
        Label lblName = new Label(parent, 0);
        lblName.setText("Name");
        this.txtName = new Text(parent, 2048);
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FunctionTypePage.this.handleErrors();
            }
        });
        Label lblType = new Label(parent, 0);
        lblType.setText("Type");
        this.cvType = new ComboViewer(parent, 8);
        this.cvType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvType.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.cvType.setInput(this.functionTypes);
        this.cvType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FunctionTypePage.this.handleErrors();
            }
        });
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 3).numColumns(3).applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.txtName);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)this.cvType.getCombo());
        this.setControl((Control)this.txtName);
        this.handleErrors();
    }

    private void handleErrors() {
        String s;
        String errorMessage = null;
        if (this.getFctType() == null) {
            errorMessage = "You have to choose a attribute type.";
        }
        if ((s = this.txtName.getText()).isEmpty()) {
            errorMessage = "The function's name cannot be empty.";
        } else if (this.attrDesc.getFct(s) != null) {
            errorMessage = "There is another function with that name.";
        }
        this.setPageComplete(errorMessage == null);
        this.setErrorMessage(errorMessage);
    }

    public String getFctName() {
        return this.txtName.getText();
    }

    public String getFctType() {
        return (String)((IStructuredSelection)this.cvType.getSelection()).getFirstElement();
    }
}

