/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.function.wizard;

import de.dfki.mycbr.core.model.SimpleAttDesc;
import de.dfki.mycbr.core.model.SymbolDesc;
import de.dfki.mycbr.core.similarity.ISimFct;
import de.dfki.mycbr.core.similarity.TaxonomyFct;
import de.dfki.mycbr.gui.function.wizard.FunctionTypePage;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class FunctionWizard
extends Wizard {
    private SimpleAttDesc attrDesc;
    private ISimFct function;

    public FunctionWizard(SimpleAttDesc attrDesc) {
        this.attrDesc = attrDesc;
    }

    public void addPages() {
        this.addPage((IWizardPage)new FunctionTypePage(this.attrDesc));
    }

    public boolean performFinish() {
        FunctionTypePage fctPage = (FunctionTypePage)this.getPage("Function type");
        ISimFct function = this.createFunction(fctPage.getFctType(), fctPage.getFctName());
        if (function != null) {
            this.function = function;
            this.attrDesc.addFct(function);
            return true;
        }
        return false;
    }

    private ISimFct createFunction(String fctType, String fctName) {
        TaxonomyFct function = null;
        try {
            if (fctType.equals("TaxonomyFct")) {
                SymbolDesc symbolDesc = (SymbolDesc)this.attrDesc;
                function = new TaxonomyFct(symbolDesc.getOwner().getProject(), symbolDesc, new ArrayList(symbolDesc.getSymbolAttributes()), fctName);
            } else {
                Class<?> fctClass = Class.forName("de.dfki.mycbr.core.similarity." + fctType);
                Constructor<?> c = fctClass.getConstructor(this.attrDesc.getOwner().getProject().getClass(), this.attrDesc.getClass(), fctName.getClass());
                function = (ISimFct)c.newInstance(this.attrDesc.getOwner().getProject(), this.attrDesc, fctName);
            }
            return function;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ISimFct getFunction() {
        return this.function;
    }
}

