/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.ie;

import de.dfki.mycbr.core.casebase.SimpleAttribute;
import de.dfki.mycbr.core.casebase.SymbolAttribute;
import de.dfki.mycbr.core.explanation.ExplanationManager;
import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.core.model.SymbolDesc;
import de.dfki.mycbr.core.similarity.ISimFct;
import de.dfki.mycbr.core.similarity.Similarity;
import de.dfki.mycbr.core.similarity.TaxonomyFct;
import de.dfki.mycbr.core.similarity.TaxonomyNode;
import de.dfki.mycbr.gui.misc.GenericTreeNode;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPRepository;

public class TaxonomyExtractor {
    private final String endpointURL = "http://dbpedia.org/sparql";
    private HTTPRepository dbpediaEndpoint;
    private RepositoryConnection conn;
    private Set<String> symbols = new HashSet<String>();
    private int maxDepth;
    private Concept concept;
    private SymbolDesc symbolDesc;
    private TaxonomyFct tax;
    private ExplanationManager explMan;
    private Set<String> allCategories = new HashSet<String>();
    private GenericTreeNode<String> allCategoriesTree;
    private Set<String> wantedCategories = new HashSet<String>();
    private String startUrl;

    public TaxonomyExtractor(Concept concept) {
        this.concept = concept;
        this.maxDepth = 1;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public String getStartUrl() {
        return this.startUrl;
    }

    public void setStartUrl(String startUrl) {
        this.startUrl = startUrl;
    }

    public void addWantedCategory(String s) {
        this.wantedCategories.add(s);
    }

    public void removeWantedCategory(String s) {
        this.wantedCategories.remove(s);
    }

    public boolean prepare() {
        this.dbpediaEndpoint = new HTTPRepository("http://dbpedia.org/sparql", "");
        try {
            this.dbpediaEndpoint.initialize();
            this.conn = this.dbpediaEndpoint.getConnection();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void close() {
        try {
            this.conn.close();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public List<String> getSubCategories(String resource) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            StringBuilder sparqlQuery = new StringBuilder();
            sparqlQuery.append("PREFIX skos: <http://www.w3.org/2004/02/skos/core#>\n");
            sparqlQuery.append("SELECT * WHERE {?category skos:broader <");
            sparqlQuery.append(resource);
            sparqlQuery.append(">}");
            TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, sparqlQuery.toString());
            TupleQueryResult queryResult = query.evaluate();
            while (queryResult.hasNext()) {
                result.add(((BindingSet)queryResult.next()).getValue("category").stringValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<String> getSymbols(String resource) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            StringBuilder sparqlQuery = new StringBuilder();
            sparqlQuery.append("PREFIX dcterms: <http://purl.org/dc/terms/>\n");
            sparqlQuery.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
            sparqlQuery.append("SELECT * WHERE {?symbol dcterms:subject <");
            sparqlQuery.append(resource);
            sparqlQuery.append("> }");
            TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, sparqlQuery.toString());
            TupleQueryResult queryResult = query.evaluate();
            while (queryResult.hasNext()) {
                result.add(((BindingSet)queryResult.next()).getValue("symbol").stringValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private TaxonomyNode findParentNode(String s) {
        for (SymbolAttribute symAttr : this.symbolDesc.getSymbolAttributes()) {
            if (!symAttr.getValue().equals(s)) continue;
            return symAttr;
        }
        return this.symbolDesc;
    }

    private void recursiveBuildTaxonomy(String url, double sim, int depth) {
        SymbolAttribute newAttr;
        if (depth > this.maxDepth) {
            return;
        }
        TaxonomyNode parentNode = this.findParentNode(this.getSymbolName(url));
        for (String category : this.getSubCategories(url)) {
            if (!this.wantedCategories.contains(category) || !this.symbols.add(category)) continue;
            newAttr = this.symbolDesc.addSymbol(this.getSymbolName(category));
            this.explMan.getExplanation((SimpleAttribute)newAttr).addLink(category);
            this.tax.setParent((TaxonomyNode)newAttr, parentNode);
            this.tax.setNodeSimilarity((TaxonomyNode)newAttr, Similarity.get((Double)(0.5 + 0.5 * sim)));
            this.recursiveBuildTaxonomy(category, 0.5 + 0.5 * sim, depth + 1);
        }
        for (String symbol : this.getSymbols(url)) {
            if (!this.symbols.add(symbol)) continue;
            newAttr = this.symbolDesc.addSymbol(this.getSymbolName(symbol));
            this.explMan.getExplanation((SimpleAttribute)newAttr).addLink(symbol);
            this.tax.setParent((TaxonomyNode)newAttr, parentNode);
            this.tax.setNodeSimilarity((TaxonomyNode)newAttr, Similarity.get((Double)(0.5 + 0.5 * sim)));
        }
    }

    public void buildTaxonomy() {
        this.symbols.clear();
        this.explMan = this.concept.getProject().getExplanationManager();
        this.symbolDesc = null;
        try {
            this.symbolDesc = new SymbolDesc(this.concept, this.getSymbolName(this.startUrl), Collections.emptySet());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.explMan.getExplanation((AttributeDesc)this.symbolDesc).addLink(this.startUrl);
        this.tax = new TaxonomyFct(this.concept.getProject(), this.symbolDesc, Collections.emptyList(), "Taxonomy");
        this.tax.setNodeSimilarity((TaxonomyNode)this.symbolDesc, Similarity.get((Double)0.5));
        this.recursiveBuildTaxonomy(this.startUrl, 0.5, 0);
        this.symbolDesc.addFct((ISimFct)this.tax);
    }

    public GenericTreeNode<String> collectCategories() {
        this.allCategories.clear();
        this.allCategoriesTree = new GenericTreeNode();
        this.recursiveCollectCategories(this.startUrl, this.allCategoriesTree, 0);
        return this.allCategoriesTree;
    }

    private void recursiveCollectCategories(String url, GenericTreeNode<String> parent, int depth) {
        if (depth >= this.maxDepth) {
            return;
        }
        for (String category : this.getSubCategories(url)) {
            if (!this.allCategories.add(category)) continue;
            GenericTreeNode<String> newNode = new GenericTreeNode<String>(category);
            parent.addChild(newNode);
            this.recursiveCollectCategories(category, newNode, depth + 1);
        }
    }

    private String getSymbolName(String s) {
        int index = s.lastIndexOf(58);
        if (index == 4) {
            index = s.lastIndexOf(47);
        }
        try {
            return URLDecoder.decode(s.substring(index + 1), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }
}

