/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.ie.wizard;

import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.gui.concept.editor.ConceptEditorInput;
import de.dfki.mycbr.gui.ie.InformationExtractionInterface;
import de.dfki.mycbr.gui.project.list.ProjectListView;
import de.dfki.mycbr.ie.InformationExtractionConfig;
import de.dfki.mycbr.ie.InformationExtractionFile;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenScoobieWizard
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object obj;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IWorkbenchPage page = window.getActivePage();
        ProjectListView view = (ProjectListView)page.findView("de.dfki.mycbr.gui.project.list.ProjectListView");
        ISelection selection = view.getSite().getSelectionProvider().getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof Concept) {
            Concept concept = (Concept)obj;
            FileDialog dialog = new FileDialog(window.getShell(), 4096);
            dialog.setFilterExtensions(new String[]{"*.XML", "*.*"});
            dialog.setFilterNames(new String[]{"XML Files (*.XML)", "*.*"});
            String fileSelected = dialog.open();
            if (fileSelected != null) {
                InformationExtractionFile ieFile = new InformationExtractionFile(fileSelected);
                InformationExtractionConfig ieConfig = new InformationExtractionConfig(concept);
                for (AttributeDesc attrDesc : concept.getAllAttributeDescs().values()) {
                    ieConfig.put(attrDesc, "", false);
                }
                InformationExtractionInterface.getInstance().put(concept, ieFile, ieConfig);
                IWorkbench workbench = PlatformUI.getWorkbench();
                try {
                    workbench.showPerspective("de.dfki.mycbr.gui.perspectives.CaseBasePerspective", window);
                }
                catch (WorkbenchException e) {
                    e.printStackTrace();
                }
                ConceptEditorInput input = new ConceptEditorInput(concept);
                try {
                    FormEditor editor = (FormEditor)page.openEditor((IEditorInput)input, "de.dfki.mycbr.gui.concept.editor.ConceptFormEditor");
                    editor.setActivePage("de.dfki.mycbr.gui.concept.editor.InformationExtractionPage");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public void dispose() {
    }
}

