/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.instance.list;

import de.dfki.mycbr.gui.filter.FilterEditorInput;
import de.dfki.mycbr.gui.filter.FilterManager;
import de.dfki.mycbr.gui.filter.IFilter;
import de.dfki.mycbr.gui.filter.InstanceFilter;
import de.dfki.mycbr.gui.filter.SetFilter;
import de.dfki.mycbr.gui.instance.list.InstanceListView;
import de.dfki.mycbr.gui.plugin.Activator;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class FilterAction
extends Action
implements ActionFactory.IWorkbenchAction,
IMenuCreator,
Observer {
    public static final String ID = "de.dfki.mycbr.gui.instance.list.FilterAction";
    static Image image = Activator.getDefault().getImageRegistry().get("caseAddIcon");
    private TableViewer viewer;
    private InstanceListView listView;
    private HashSet<ViewerFilter> activeFilter = new HashSet();
    private Menu fMenu;
    private Control parent;

    public FilterAction(TableViewer viewer, InstanceListView listView) {
        super("&Filter", 4);
        this.viewer = viewer;
        this.setId(ID);
        this.listView = listView;
        this.setText("&Filter");
        this.setToolTipText("Filter...");
        this.setImageDescriptor(Activator.getImageDescriptor("/icons/filter.gif"));
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(final Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.parent = parent;
        this.fMenu = new Menu(parent);
        FilterManager.getInstance().addObserver(this);
        for (IFilter f : FilterManager.getInstance().getFilter(this.listView.getCurrentConcept().getProject())) {
            this.addActionToMenu(this.fMenu, new FilterActionEntry(f.getID(), f));
        }
        Separator item = new Separator("new Filter");
        item.fill(this.fMenu, -1);
        Action newFilterAction = new Action("New Filter..."){

            public void run() {
                Display display = parent.getDisplay();
                final Shell shell = new Shell(display);
                shell.setText("New Filter");
                shell.setBounds(shell.getBounds().x, shell.getBounds().y, 250, 300);
                GridLayout layout = new GridLayout(2, false);
                shell.setLayout((Layout)layout);
                Label label = new Label((Composite)shell, 0);
                label.setText("Filter ID");
                GridData gridData = new GridData(0, 0x1000000, false, false);
                label.setLayoutData((Object)gridData);
                final Text IDtxt = new Text((Composite)shell, 2048);
                gridData = new GridData(4, 0, true, false);
                gridData.horizontalIndent = 10;
                IDtxt.setLayoutData((Object)gridData);
                label = new Label((Composite)shell, 258);
                gridData = new GridData(4, 1, true, false, 2, 1);
                gridData.horizontalSpan = 2;
                label.setLayoutData((Object)gridData);
                Group group = new Group((Composite)shell, 0);
                group.setText("Filter by");
                gridData = new GridData(4, 4, true, true);
                gridData.horizontalSpan = 2;
                group.setLayoutData((Object)gridData);
                group.setLayout((Layout)new RowLayout(512));
                final Button b1 = new Button((Composite)group, 16);
                b1.setSelection(true);
                b1.setText("ID");
                b1.pack();
                Button b2 = new Button((Composite)group, 16);
                b2.setText("attribute");
                b2.pack();
                Button createButton = new Button((Composite)shell, 8);
                createButton.setText("create");
                gridData = new GridData(0x1000008, 0, true, false);
                gridData.horizontalSpan = 2;
                createButton.setLayoutData((Object)gridData);
                createButton.addMouseListener(new MouseListener(){

                    public void mouseUp(MouseEvent e) {
                    }

                    public void mouseDown(MouseEvent e) {
                        ViewerFilter f;
                        if (b1.getSelection()) {
                            f = new SetFilter(FilterAction.this.listView.getCurrentConcept().getProject());
                            ((SetFilter)f).setApplyType(SetFilter.ApplicableType.INSTANCE);
                        } else {
                            f = new InstanceFilter(FilterAction.this.listView.getCurrentConcept());
                        }
                        f.setID(IDtxt.getText());
                        FilterEditorInput input = new FilterEditorInput((IFilter)f);
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "de.dfki.mycbr.gui.filter.FilterEditor");
                        }
                        catch (PartInitException exp) {
                            exp.printStackTrace();
                        }
                        shell.dispose();
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                    }
                });
                shell.pack();
                shell.open();
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        };
        this.addActionToMenu(this.fMenu, newFilterAction);
        Action resetFilterAction = new Action("Reset Filters"){

            public void run() {
                FilterAction.this.viewer.resetFilters();
                FilterAction.this.listView.clear();
                FilterAction.this.listView.fillTable();
            }
        };
        this.addActionToMenu(this.fMenu, resetFilterAction);
        return this.fMenu;
    }

    protected void addActionToMenu(Menu m, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(m, -1);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof FilterManager) {
            this.parent.setMenu(this.getMenu(this.parent));
        }
    }

    class FilterActionEntry
    extends Action {
        private IFilter f;

        public FilterActionEntry(String ID, IFilter f) {
            super(ID, ImageDescriptor.createFromImage((Image)image));
            this.f = f;
        }

        public void run() {
            this.toggleFilter(this.f);
        }

        private void toggleFilter(IFilter f) {
            if (FilterAction.this.activeFilter.contains(f)) {
                FilterAction.this.activeFilter.remove(f);
                FilterAction.this.viewer.resetFilters();
                for (ViewerFilter filter : FilterAction.this.activeFilter) {
                    FilterAction.this.viewer.addFilter(filter);
                }
                this.setText(String.valueOf(f.getID()) + "x");
                FilterAction.this.parent.redraw();
            } else {
                FilterAction.this.activeFilter.add((ViewerFilter)f);
                FilterAction.this.viewer.addFilter((ViewerFilter)f);
                this.setText(String.valueOf(f.getID()) + "!");
                FilterAction.this.fMenu.reskin(1);
                FilterAction.this.parent.redraw();
            }
            FilterAction.this.listView.clear();
            FilterAction.this.listView.fillTable();
        }
    }
}

