/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenericTreeNode<T> {
    private T data;
    private List<GenericTreeNode<T>> children = new ArrayList<GenericTreeNode<T>>();
    private GenericTreeNode<T> parent;

    public GenericTreeNode() {
    }

    public GenericTreeNode(T data) {
        this();
        this.setData(data);
    }

    public List<GenericTreeNode<T>> getChildren() {
        return this.children;
    }

    public int getNumberOfChildren() {
        return this.getChildren().size();
    }

    public boolean hasChildren() {
        return this.getNumberOfChildren() > 0;
    }

    public GenericTreeNode<T> getParent() {
        return this.parent;
    }

    public void setChildren(List<GenericTreeNode<T>> children) {
        this.children = children;
    }

    public void addChild(GenericTreeNode<T> child) {
        this.children.add(child);
        child.parent = this;
    }

    public void addChildAt(int index, GenericTreeNode<T> child) throws IndexOutOfBoundsException {
        this.children.add(index, child);
        child.parent = this;
    }

    public void removeChildren() {
        this.children = new ArrayList<GenericTreeNode<T>>();
    }

    public void removeChildAt(int index) throws IndexOutOfBoundsException {
        this.children.remove(index);
    }

    public GenericTreeNode<T> getChildAt(int index) throws IndexOutOfBoundsException {
        return this.children.get(index);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return this.getData().toString();
    }

    public boolean equals(GenericTreeNode<T> node) {
        return node.getData().equals(this.getData());
    }

    public int hashCode() {
        return this.getData().hashCode();
    }

    public String toStringVerbose() {
        String stringRepresentation = String.valueOf(this.getData().toString()) + ":[";
        for (GenericTreeNode<T> node : this.getChildren()) {
            stringRepresentation = String.valueOf(stringRepresentation) + node.getData().toString() + ", ";
        }
        Pattern pattern = Pattern.compile(", $", 32);
        Matcher matcher = pattern.matcher(stringRepresentation);
        stringRepresentation = matcher.replaceFirst("");
        stringRepresentation = String.valueOf(stringRepresentation) + "]";
        return stringRepresentation;
    }
}

