/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.mycbr.gui.project.list;

import de.dfki.mycbr.core.Project;
import de.dfki.mycbr.core.model.AttributeDesc;
import de.dfki.mycbr.core.model.Concept;
import de.dfki.mycbr.gui.attribute.editor.AttributeEditorInput;
import de.dfki.mycbr.gui.concept.editor.ConceptEditorInput;
import de.dfki.mycbr.gui.function.editor.AmalgamationEditorInput;
import de.dfki.mycbr.gui.function.editor.FunctionEditorInput;
import de.dfki.mycbr.gui.function.list.FunctionListView;
import de.dfki.mycbr.gui.project.list.ProjectListView;
import de.dfki.mycbr.gui.retrieval.editor.RetrievalEditorInput;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DeleteHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        ProjectListView view = (ProjectListView)page.findView("de.dfki.mycbr.gui.project.list.ProjectListView");
        ISelection selection = view.getSite().getSelectionProvider().getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof Project) {
                MessageDialog.openWarning((Shell)window.getShell(), (String)"Warning", (String)"You cannot delete the whole project.");
            } else if (obj instanceof Concept) {
                Concept concept = (Concept)obj;
                if (MessageDialog.openConfirm((Shell)window.getShell(), (String)"Confirm Deletion", (String)"You are about to delete a concept. Are you sure? All subconcepts and attribute descriptions will be deleted, as well as all entries in the case base.")) {
                    IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                    int n = iEditorReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference editorReference = iEditorReferenceArray[n2];
                        try {
                            Object input;
                            IEditorInput editorInput = editorReference.getEditorInput();
                            if (editorInput instanceof ConceptEditorInput) {
                                input = (ConceptEditorInput)editorInput;
                                if (((ConceptEditorInput)input).getConcept().equals(concept)) {
                                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorReference.getEditor(false), false);
                                }
                            } else if (editorInput instanceof AttributeEditorInput) {
                                input = (AttributeEditorInput)editorInput;
                                if (((AttributeEditorInput)input).getAttribute().getOwner().equals(concept)) {
                                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorReference.getEditor(false), false);
                                }
                            } else if (editorInput instanceof RetrievalEditorInput) {
                                input = (RetrievalEditorInput)editorInput;
                                if (((RetrievalEditorInput)input).getConcept().equals(concept)) {
                                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorReference.getEditor(false), false);
                                }
                            } else if (editorInput instanceof FunctionEditorInput) {
                                input = (FunctionEditorInput)editorInput;
                                if (input.getFunction().getDesc().getOwner().equals(concept)) {
                                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorReference.getEditor(false), false);
                                }
                            } else if (editorInput instanceof AmalgamationEditorInput && ((AmalgamationEditorInput)(input = (AmalgamationEditorInput)editorInput)).getFunction().getConcept().equals(concept)) {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorReference.getEditor(false), false);
                            }
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                        ++n2;
                    }
                    FunctionListView functionView = (FunctionListView)page.findView("de.dfki.mycbr.gui.function.list.FunctionListView");
                    if (functionView != null && concept.equals(functionView.getCurrentSource())) {
                        functionView.clear();
                    }
                    try {
                        if (!concept.getProject().getName().endsWith("_UNSAFED")) {
                            concept.getProject().setName(String.valueOf(concept.getProject().getName()) + "_UNSAFED");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    concept.getSuperConcept().removeSubConcept(concept.getName());
                }
            } else if (obj instanceof AttributeDesc) {
                AttributeDesc attribute = (AttributeDesc)obj;
                Concept concept = attribute.getOwner();
                if (MessageDialog.openConfirm((Shell)window.getShell(), (String)"Confirm Deletion", (String)("Are you sure that you want to delete the attribute '" + attribute.getName() + "'? The related values will be deleted from the case base."))) {
                    IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                    int n = iEditorReferenceArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IEditorReference editorReference = iEditorReferenceArray[n3];
                        try {
                            Object input;
                            IEditorInput editorInput = editorReference.getEditorInput();
                            if (editorInput instanceof AttributeEditorInput) {
                                input = (AttributeEditorInput)editorInput;
                                if (((AttributeEditorInput)input).getAttribute().equals(attribute)) {
                                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorReference.getEditor(false), false);
                                }
                            } else if (editorInput instanceof FunctionEditorInput && (input = (FunctionEditorInput)editorInput).getFunction().getDesc().equals(attribute)) {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorReference.getEditor(false), false);
                            }
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                        ++n3;
                    }
                    FunctionListView functionView = (FunctionListView)page.findView("de.dfki.mycbr.gui.function.list.FunctionListView");
                    if (functionView != null && attribute.equals(functionView.getCurrentSource())) {
                        functionView.clear();
                    }
                    concept.removeAttributeDesc(attribute.getName());
                    try {
                        if (!concept.getProject().getName().endsWith("_UNSAFED")) {
                            concept.getProject().setName(String.valueOf(concept.getProject().getName()) + "_UNSAFED");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            view.refresh();
        }
        return null;
    }

    public void dispose() {
    }
}

